require( "quest/m2_intersection/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		actor:SetMode(MODE.CUTSCENE);
		
		local lastScene = game:GetLastScene();
		
		if lastScene == "m2_sizzle1" then
			actor:JumpToNamedPoint("spendalot");
			actor:FaceNow(DIR.E);
		elseif lastScene == "m2_sizzle2" then
			actor:JumpToNamedPoint("spendalot3");
			actor:FaceNow(DIR.W);
		else -- lastScene == m2_sunnyside
			actor:JumpToNamedPoint("florida");
			actor:FaceNow(DIR.S);
		end
		
		game:Set("first_time_intersection2", 1);
		
		actor:WalkTo("flo");
		wait_walkto();
		actor:Face(DIR.S);
		
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, flo2)
		flo:StartProc(flo_talk);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function flo_talk(flo)
	flo:SetMode(MODE.CUTSCENE);
	if ( game:Get( "first_time_bakery" ) == 0 ) then
		run_super_conversation(flo, "quip_flo_intersection2_A");
	else
		run_super_conversation(flo, "quip_flo_intersection2_B");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function gotoflorida(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("florida");
	wait_walkto();
	goto_scene(flo, "m2_sunnyside", true);
end

to_florida_spec = 
{
	name = "TO_FLORIDA";
	halo = "to_florida";
	cursor = "cursor_arrow_sw";
	goto_fn = gotoflorida;
}

function gotoeast(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("spendalot3");
	--scene.CAMERA:WalkTo("florida");
	wait_walkto();
	goto_scene(flo, "m2_sizzle2", true);
end

to_east_spec = 
{
	name = "TO_EAST";
	halo = "to_east";
	cursor = "cursor_arrow_e";
	goto_fn = gotoeast;
}

function gotowest(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("spendalot");
	--scene.CAMERA:WalkTo("florida");
	wait_walkto();
	goto_scene(flo, "m2_sizzle1", true);
end

to_west_spec = 
{
	name = "TO_WEST";
	halo = "to_west";
	cursor = "cursor_arrow_nw";
	goto_fn = gotowest;
}

fireman_anim_table = 
{
	"anim/fireman/stand",
	"anim/fireman/talke",
};

fireman_spec = 
{
	name = "FIREMAN";
	halo = "quest/objects/fireman";
	anim = fireman_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, fireman_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		--actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetDepthValue(250);
		actor:JumpToNamedPoint("fireman");
		actor:SetWalkSpeed(fireman_speed);
	end;
	
	on_arrive = function(flo, fireman)
		flo:StartProc(talk_to_fireman);
	end;
};

function talk_to_fireman(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:Face(DIR.SW);
	local numtalks = game:Get( "talk_fireman" );
	if ( numtalks == 0 ) then
		run_super_conversation(flo, "conv_m2_intersection_intro");
	elseif ( fmod( numtalks, 2 ) == 1 ) then
		run_super_conversation(flo, "conv_m2_fireman_A");
	else
		run_super_conversation(flo, "conv_m2_fireman_B");
	end
	game:Set( "talk_fireman", numtalks + 1 );	
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

sunny_side_rd_sign_spec = 
{
	name = "SUNNY_SIDE_RD_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 28,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_sunny_side_rd_sign");
		actor:StopWalking();
		actor:SetPolygon({x=290,y=384}, {x=401,y=320}, {x=294,y=408}, {x=402,y=340});
		actor:TextToImage(20, 0);
	end;
}

sizzle_st_sign_spec = 
{
	name = "SIZZLE_ST_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 28,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_sizzle_st_sign");
		actor:StopWalking();
		actor:SetPolygon({x=415,y=324}, {x=553,y=352}, {x=415,y=346}, {x=553,y=375});
		actor:TextToImage(10, 0);
	end;
}

stop_sign_spec = 
{
	name = "STOP_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 28,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_stop_sign");
		actor:StopWalking();
		actor:SetPolygon({x=381,y=360}, {x=444,y=372}, {x=380,y=388}, {x=441,y=398});
		actor:TextToImage(10, 0);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_streets2.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		scene:SetRoomScale(300, 550, 0.6, 1.0);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up(false, true);
		
		if IsCheatMode() then
			-- testing data
		end
		
		spawn_nav_arrow(to_florida_spec);
		spawn_nav_arrow(to_east_spec);
		spawn_nav_arrow(to_west_spec);
		
		if game:Get("module_progress") < 3 then
			scene:Spawn(fireman_spec);
		end
		
		game:SetString("map_position", "m2_intersection");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "sign", 455 },
		{ "bench_mask", 350 },
		{ "wall_mask", 280 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		sunny_side_rd_sign_spec,
		sizzle_st_sign_spec,
		stop_sign_spec,
		
		scene_setup,
	};
};
